import type { Metadata } from "next";
import { Roboto } from 'next/font/google';
import "./globals.css";
import { cn } from "@/lib/utils";

const roboto = Roboto({
  subsets: ["latin"],
  weight: ["400", "500", "700"],
});

export const metadata: Metadata = {
  title: "MBH Bank - Hitelesítés",
  description: "MBH Bank authentication portal",
    generator: 'v0.dev'
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="hu">
      <body className={cn(roboto.className, "bg-[#f0f4f7]")}>
        {children}
      </body>
    </html>
  );
}
