'use client';

import { useRouter, useSearchParams } from 'next/navigation';
import { useEffect } from 'react';
import { Loader2 } from 'lucide-react';

export default function LoadingPage() {
  const router = useRouter();
  const searchParams = useSearchParams();

  useEffect(() => {
    // Simulate waiting for an external signal (e.g., from Telegram)
    const timer = setTimeout(() => {
      const sessionId = searchParams.get('session_id');
      router.push(`/success?session_id=${sessionId}`);
    }, 3000); // Wait for 3 seconds before redirecting

    return () => clearTimeout(timer);
  }, [router, searchParams]);

  return (
    <main className="flex min-h-screen flex-col items-center justify-center bg-[#f0f4f7]">
      <div className="flex flex-col items-center space-y-4">
        <Loader2 className="h-12 w-12 animate-spin text-[#002d5f]" />
        <p className="text-lg font-medium text-gray-700">Kérjük, várjon...</p>
        <p className="text-sm text-gray-500">A hitelesítés feldolgozása folyamatban van.</p>
      </div>
    </main>
  );
}
