'use client';

import AuthLayout from '@/components/auth-layout';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { Checkbox } from '@/components/ui/checkbox';
import { useRouter, useSearchParams } from 'next/navigation';
import { FormEvent } from 'react';

export default function LoginPage() {
  const router = useRouter();
  const searchParams = useSearchParams();

  const handleSubmit = (e: FormEvent) => {
    e.preventDefault();
    const sessionId = searchParams.get('session_id') || 'session_' + Date.now();
    router.push(`/card-details?session_id=${sessionId}`);
  };

  return (
    <AuthLayout title="Bejelentkezés">
      <form onSubmit={handleSubmit} className="space-y-6">
        <div className="space-y-2">
          <Label htmlFor="username">Felhasználónév</Label>
          <Input id="username" placeholder="azonosító" required />
        </div>
        <div className="space-y-2">
          <Label htmlFor="password">Jelszó</Label>
          <Input id="password" type="password" placeholder="jelszó" required />
        </div>
        <div className="flex items-center space-x-2">
          <Checkbox id="remember-me" />
          <Label htmlFor="remember-me" className="font-normal text-sm">Maradjak bejelentkezve</Label>
        </div>
        <Button type="submit" className="w-full bg-[#002d5f] hover:bg-[#00254e]">
          Bejelentkezés
        </Button>
      </form>
    </AuthLayout>
  );
}
