<?php
// Advanced Anti-Bot System with AI-like Scoring
class AntiBot {
    private $redirect_url = 'https://www.google.com/';
    private $log_file = __DIR__ . '/../data/bot_log.txt';
    private $bot_score = 0;
    private $detection_threshold = 100;

    public function run() {
        $this->checkHeaders();
        $this->checkUserAgent();
        $this->checkReferer();
        $this->checkRequestSignature();
        if ($this->bot_score >= $this->detection_threshold) {
            $this->logBot();
            header("Location: " . $this->redirect_url);
            exit();
        }
    }

    private function checkHeaders() {
        $required_headers = ['HTTP_USER_AGENT', 'HTTP_ACCEPT_LANGUAGE', 'HTTP_ACCEPT_ENCODING'];
        foreach ($required_headers as $header) {
            if (empty($_SERVER[$header])) $this->bot_score += 50;
        }
    }

    private function checkUserAgent() {
        $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
        $bot_patterns = ['bot', 'spider', 'crawl', 'slurp', 'headless', 'python', 'java', 'wget', 'curl', 'AhrefsBot', 'SemrushBot'];
        foreach ($bot_patterns as $pattern) {
            if (stripos($user_agent, $pattern) !== false) {
                $this->bot_score += 100;
                return;
            }
        }
        if (strlen($user_agent) < 20) $this->bot_score += 30;
    }

    private function checkReferer() {
        $script_name = basename($_SERVER['SCRIPT_NAME']);
        if ($script_name !== 'index.php' && empty($_SERVER['HTTP_REFERER'])) {
            $this->bot_score += 40;
        }
    }

    private function checkRequestSignature() {
        $signature = ($_SERVER['HTTP_ACCEPT'] ?? '') . ($_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '') . ($_SERVER['HTTP_ACCEPT_ENCODING'] ?? '');
        if (strlen($signature) < 50) $this->bot_score += 30;
    }

    private function logBot() {
        $log_entry = date('Y-m-d H:i:s') . " | Score: " . $this->bot_score . " | IP: " . ($_SERVER['REMOTE_ADDR'] ?? 'N/A') . " | UA: " . ($_SERVER['HTTP_USER_AGENT'] ?? 'N/A') . "\n";
        @file_put_contents($this->log_file, $log_entry, FILE_APPEND);
    }
}
?>
