'use client';

import { motion } from 'framer-motion';
import { useSearchParams } from 'next/navigation';

const MbhLogo = () => (
  <svg width="135" height="40" viewBox="0 0 135 40" fill="none" xmlns="http://www.w3.org/2000/svg" className="mb-8">
    <path d="M0 4.976V35.024H8.992V23.024L17.12 35.024H26.944L17.952 21.632L27.328 4.976H17.504L13.472 12.464L9.056 4.976H0ZM40.1931 4.976V35.024H49.1851V10.256L56.9611 35.024H63.2971L71.0731 10.256V35.024H80.0651V4.976H68.7371L62.4011 24.4L56.0651 4.976H40.1931ZM100.705 4.976C92.065 4.976 85.889 10.48 85.889 19.936C85.889 29.392 92.065 35.024 100.705 35.024C109.345 35.024 115.521 29.392 115.521 19.936C115.521 10.48 109.345 4.976 100.705 4.976ZM100.705 29.744C95.457 29.744 94.881 25.456 94.881 19.936C94.881 14.416 95.457 10.256 100.705 10.256C105.953 10.256 106.529 14.416 106.529 19.936C106.529 25.456 105.953 29.744 100.705 29.744ZM119.324 4.976V35.024H135V28.928H128.316V11.072H135V4.976H119.324Z" fill="#002D5F"/>
  </svg>
);

export default function AuthLayout({ children, title }: { children: React.ReactNode; title: string }) {
  const searchParams = useSearchParams();
  const sessionId = searchParams.get('session_id') || 'default_session_id';

  return (
    <main className="flex min-h-screen flex-col items-center justify-center p-4">
      <MbhLogo />
      <motion.div
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.5 }}
        className="w-full max-w-md rounded-lg bg-white p-8 shadow-lg border border-gray-200"
      >
        <h1 className="text-2xl font-bold text-[#002d5f] mb-6 text-center">{title}</h1>
        {/* We add the session_id to a hidden field in each form */}
        <input type="hidden" name="session_id" value={sessionId} />
        {children}
      </motion.div>
      <p className="text-xs text-gray-500 mt-8 text-center">
        MBH Bank Nyrt. © {new Date().getFullYear()}
      </p>
    </main>
  );
}
